<?php
// =====================================================================================================
// Speed Test (read)- MYSQL Database on 137.59.109.53
// ======================================================================================================
//
//
$debug = true;          // set if required to execute all the debug codes
$testrange = true;       // set if needed to
$errormsg = "";

// test database and parameters
$daterange1 = "2018-01-01";
$daterange2 = "2019-03-31";
$emastdbparam[0] = "mysql:host=137.59.109.53;dbname=emas_tpa_test";
$emastdbparam[1] = "SOLIDSNAKE";
$emastdbparam[2] = "9MNTAPdtL3xnfs";

$counterx = 30000;


echo "======= Read Test Using 137.59.109.53 Server =======<br />";

if ($debug){
	echo "<pre>";
	echo "=============criteria Entered=============<br />";
	echo print_r($daterange1)."<br />";
	echo print_r($daterange2)."<br />";
	echo print_r($emastdbparam)."<br />";
	echo print_r($counterx)."<br />";
	echo "==========================================<br />";
	echo "</pre>";
};


$emastquery = "select
claim_id as ClaimId,
claim_date as ClaimDate,
corp_id as CorpId,
patient_name as PatientName,
claim_gross_amount as ClaimAmount

From
tbl_payment_detail

Where
claim_date between '$daterange1' and '$daterange2'";

if ($debug) {
    echo "<pre>";
    echo "====  MySQL structure ========<br />";
    echo print_r($emastquery)."<br />";
    echo "</pre>";
}

try {
    $emasthandle = new PDO($emastdbparam[0],$emastdbparam[1],$emastdbparam[2]);
    $emasthandle->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	$emastset = $emasthandle->query($emastquery);
}
catch (PDOException $e) {
    $errormsg = "Connection - ".$emastdbparam[0]." failed: ".$e->getMessage();
//  trigger_error($errormsg, E_USER_ERROR);
    if ($debug) {
        echo "<pre>";
	    echo print_r($errormsg)."<br />";
	    echo "</pre>";
    }
    return;
}
if ($debug) {
    echo "<pre>";
    echo "Connection to emas_tpa Server Successful <br />";
    echo "</pre>";
}

$starttime = strtotime(date("Y-m-d H:i:s"));
$startdatetime = date("Y-m-d H:i:s");

//
// ================ Start the query loop and Get Record from MSSQL DB ================
//
$continueloop = true;
$counter = 1;

while ($continueloop) {
    if ($testrange) {
        if ($counter > $counterx){
			$endtime = strtotime(date("Y-m-d H:i:s"));
			$enddatetime = date("Y-m-d H:i:s");
			$continueloop = false;
			continue;
        }
    }
    $counter++;
    try {
        $emastrow = $emastset->fetch(PDO::FETCH_ASSOC);

    }
    catch (PDOException $e) {
        $errormsg = "Read from MYSQL ".$e->getMessage();
    //  trigger_error($errormsg, E_USER_ERROR);
        if ($debug) {
            echo "<pre>";
            echo print_r($errormsg)."<br />";
            echo "</pre>";
        }
        return;
    }
    if ($debug) {
        echo "<pre>";
        echo "Read Record No. $counter from MYSQL Successful <br />";
        echo print_r($emastrow)."<br />";
        echo "</pre>";
    }
    if (empty($emastrow)) {           // terminate loop if the row read is empty
        if ($debug) {
            echo "<pre>";
            echo "Read from MYSQL - empty record after $counter <br />";
            echo print_r($emastrow)."<br />";
            echo "</pre>";
            echo "</pre>";
        }
		$endtime = strtotime(date("Y-m-d H:i:s"));
		$enddatetime = date("Y-m-d H:i:s");
		$continueloop = false;
		Continue;
    }

}

echo "<pre>";
echo "==== $counter loops completed <br />";
echo "==== Startdatetime1 $startdatetime === <br />";
echo "==== enddatetime $enddatetime === <br />";
echo "==== Starttime $starttime === <br />";
echo "==== Sendtime $endtime === <br />";
$timediff = abs($endtime - $starttime)/60;
echo "==== Time taken $timediff === <br />";
echo "</pre>";
$mssqlhandle = null;

?>
